﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Register TagPrefix="n0" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Paski wypłat</title>
    <script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }
            
        //static bool procentInfo = false;
        bool procentInfo = false;
        [Priority(1)]
        [Caption("Kolumna %")]
        public bool ProcentInfo {
            get { return procentInfo; }
            set {
                procentInfo = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //static bool skladnikiInfo = false;
        bool skladnikiInfo = false;
        [Priority(2)]
        [Caption("Szczegółowe dane")]
        public bool SkladnikiInfo {
            get { return skladnikiInfo; }
            set {
                skladnikiInfo = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //static bool procentPit = false;
        bool procentPit = false;
        [Priority(3)]
        [Caption("Kolumna % PIT")]
        public bool ProcentPit {
            get { return procentPit; }
            set {
                procentPit = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //Włącza drukowanie podsumowania funduszy pożyczkowych. UWAGA! Informacja wg stanu
        //aktualnego a nie na dzień wypłaty.
        //static bool funduszePożyczkowe = false;
        bool funduszePożyczkowe = false;
        [Priority(4)]
        [Caption("Fundusze pożyczkowe")]
        public bool FunduszePożyczkowe {
            get { return funduszePożyczkowe; }
            set {
                funduszePożyczkowe = value;
                OnChanged(EventArgs.Empty);
            }
        }

        //static bool daneFirmy = true;
        bool daneFirmy = true;
        [Priority(5)]
        [Caption("Dane firmy")]
        public bool DaneFirmy {
            get { return daneFirmy; }
            set {
                daneFirmy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool fundusze = true;
        [Priority(6)]
        [Caption("Fundusze")]
        public bool Fundusze {
            get { return fundusze; }
            set {
                fundusze = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool infoNorma = false;
        [Priority(7)]
        [Caption("Informacja o normie")]
        public bool InfoNorma {
            get { return infoNorma; }
            set {
                infoNorma = value;
                OnChanged(EventArgs.Empty);
            }
        }

        bool oswiadczenie = true;
        [Priority(8)]
        [Caption("Oświadczenie płatnika")]
        public bool Oswiadczenie {
            get { return oswiadczenie; }
            set {
                oswiadczenie = value;
                OnChanged(EventArgs.Empty);
            }
        }                                                  
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
        
    private void gridHeader_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        Wyplata wypłata = dc[typeof(Wyplata)] as Wyplata;

        KalkulatorPracownika kalk = new KalkulatorPracownika(wypłata.Pracownik);
        CzasDni norma = kalk.Norma(wypłata.ListaPlac.Okres);
        string value = "<b>" + wypłata.ListaPlac.Okres + "</b>";
        if (srpars.InfoNorma)
            value += ", Norma: <b>" + norma.Czas + " / " + norma.Dni + "</b>";
       col_1_OkresInfo.EditValue = col_2_OkresInfo.EditValue = value;

        WyplataEtat we = wypłata as WyplataEtat;
        Wyplata.ZUSInfoWorker zusinfo = new Wyplata.ZUSInfoWorker();
        zusinfo.Wypłata = wypłata;
        if (we != null)
           col_1_PracInfo.EditValue = col_2_PracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Wymiar etatu: <strong>{1}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{2}</strong>",
                wypłata.PracHistoria.PESEL,
                wypłata.PracHistoria.Etat.Zaszeregowanie.Wymiar,
                zusinfo.TytułUbezpieczenia);
        else {
            Umowa umowa = wypłata is WyplataUmowa ? ((WyplataUmowa)wypłata).Umowa : null;
            if (umowa != null)
               col_1_PracInfo.EditValue = col_2_PracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tytuł ubezpieczenia: <strong>{1}</strong>",
                    wypłata.PracHistoria.PESEL,
                    zusinfo.TytułUbezpieczenia);
            else
               col_1_PracInfo.EditValue = col_2_PracInfo.EditValue = string.Format("PESEL: <strong>{0}</strong>",
                    wypłata.PracHistoria.PESEL);
        }
        
        Currency ror = wypłata.Inne;
       col_1_Gotowka.EditValue = col_2_Gotowka.EditValue = wypłata.WartoscCy-ror;
       col_1_ROR.EditValue = col_2_ROR.EditValue = ror;

       
    }

        private string Korygowany(WypElement element) {
            return element.TranslatedName();
        }
    
    static readonly string prefix = "&nbsp;&nbsp;&nbsp;&nbsp;";
	private void gridElements_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        WypElement element = (WypElement)args.Row;

        if (!srpars.SkladnikiInfo) {
			if (element.Wartosc==0)
				args.VisibleRow = false;
			else {
				colNazwa.AddLine(Korygowany(element));
				WypSkladnikGłówny skg = element.SkładnikGłówny;
				colProcent.AddLine(skg==null ? Percent.Zero : skg.Procent);
				colCzas.AddLine(element.Czas);
				colDni.AddLine(element.Dni);
				AddWartosc(element.Wartosc);
			}
        }
		else 
			foreach (WypSkladnik sk in element.Skladniki) {
				WypSkladnikGłówny skg = sk as WypSkladnikGłówny;
				if (skg!=null) {
					colNazwa.AddLine(Korygowany(element));
					colProcent.AddLine(skg.Procent);
					colCzas.AddLine(skg.Czas);
					colDni.AddLine(skg.Dni);
					AddWartosc(skg.Wartosc);
				}
				else {
					WypSkladnikPomniejszenie skp = sk as WypSkladnikPomniejszenie;
					if (skp!=null) {
						colNazwa.AddLine(prefix + skp.Nieobecnosc.Definicja.Nazwa + " (" + skp.Okres + ")");
						colProcent.AddLine(skp.Procent);
						colCzas.AddLine(skp.Czas);
						colDni.AddLine(skp.Dni);
						colDodatek.AddLine(skp.Wartosc);
						colPotracenie.AddLine(0m);
					}
					else {
						colNazwa.AddLine(prefix + CaptionAttribute.EnumToString(sk.Rodzaj));
						colProcent.AddLine(sk.Procent);
						colCzas.AddLine(sk.Czas);
						colDni.AddLine(sk.Dni);
						colDodatek.AddLine(sk.Wartosc);
						colPotracenie.AddLine(0m);
					}
				}
			}            
    }
    
    void AddWartosc(decimal v) {
		if (v>=0) {
			colDodatek.AddLine(v);
			colPotracenie.AddLine(0m);
		}
		else {
			colDodatek.AddLine(0m);
			colPotracenie.AddLine(-v);
		}
    }

    private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

    private void dc_ContextLoad(object sender, System.EventArgs e) {
        if (!srpars.ProcentPit) {
			col_1_PitInfo.Format = col_2_PitInfo.Format = "";
			col_1_PitProcent.DataMember = col_2_PitProcent.DataMember = "";			
		}
        section1.Visible = srpars.Oswiadczenie;
        
        Wyplata wypłata = (Wyplata)dc[typeof(Wyplata)];
        gridHeader1.DataSource = gridHeader.DataSource = new object [] {new ContextObject(wypłata, dc.Context) };

         if (wypłata.Data.Year < 2022)
            {
                GridColumn9.Format = "Zdrow.do odlicz:";
                GridColumn9_1.Format = "Zdrow.do odlicz:";
                GridColumn10.DataMember = "Workers.PITInfo.ZdrowotneDoOdliczenia";
                GridColumn10_1.DataMember = "Workers.PITInfo.ZdrowotneDoOdliczenia";
            }
            else
            {
                GridColumn9.Format = "Ulga klasa średnia";
                GridColumn9_1.Format = "Ulga klasa średnia";
                GridColumn10.DataMember = "Workers.PITInfo.UlgaKlasaSrednia";
                GridColumn10_1.DataMember = "Workers.PITInfo.UlgaKlasaSrednia";
            }

       colProcent.Visible = srpars.ProcentInfo;
		
		ArrayList fundusze = new ArrayList();
		foreach (FundPozyczkowy f in wypłata.Pracownik.FunduszePozyczkowe)
			fundusze.Add(f);

        if (fundusze.Count == 0 || !srpars.FunduszePożyczkowe || !(wypłata is WyplataEtat))
			gridFundusze.Visible = false;
		else {
			ListWithView lvw = new ListWithView(fundusze, wypłata.Pracownik.Module.FundPozyczkowe.PrimaryKey);
			gridFundusze.DataSource = lvw;
		}

        if (srpars.DaneFirmy) {
		    CoreModule core = CoreModule.GetInstance(dc);
            string nip = core.Config.Firma.Pieczątka.NIP;
            string regon = core.Config.Firma.Pieczątka.REGON;
            string nazwa = core.Config.Firma.Pieczątka.Nazwa;
            PracHistoria ph = wypłata.PracHistoria;
            if (ph.Etat.Wydzial != null && ph.Etat.Wydzial.Oddzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                if (!string.IsNullOrEmpty(of.Deklaracje.NIP)) nip = of.Deklaracje.NIP;
                if (!string.IsNullOrEmpty(of.Deklaracje.REGON)) regon = of.Deklaracje.REGON;
                if (!string.IsNullOrEmpty(of.Nazwa)) nazwa = of.Nazwa;
            }
           colNazwaFirmy.Format = string.Format("<strong>{0}</strong>", nazwa);
           colNIP.Format = string.Format("<strong>{0}</strong>", nip);
            GridFirma.DataSource = new object[] { dc.Session };
    		colNuspTitle.Format = "REGON:";
           colNUSP.Format = string.Format("<strong>{0}</strong>", regon);
		}
        else
            GridFirma.Visible = srpars.DaneFirmy;

        bool ppk = JestPPK(wypłata, wypłata.ListaPlac.DataWyplaty);

        sectionPPK.Visible = ppk;
        sectionNormal.Visible = !ppk;

        if (!srpars.Fundusze && !ppk) {
            gridHeader1.RowsInRow -= 3;

            opt_2_EmptyBegin.Visible = false;
            opt_2_Podstawa.Visible = false;
            opt_2_Skladka.Visible = false;

            opt_2_FP.Visible = false;
            opt_2_FPPodstawa.Visible = false;
            opt_2_FPSkladka.Visible = false;

            opt_2_FGSP.Visible = false;
            opt_2_FGSPPodstawa.Visible = false;
            opt_2_FGSPSkladka.Visible = false;

            opt_2_FEP.Visible = false;
            opt_2_FEPPodstawa.Visible = false;
            opt_2_FEPSkladka.Visible = false;

            opt_2_EmptyEnd.Visible = false;
        }

        if (srpars.Fundusze && ppk) {
            opt_1_EmptyEnd.Visible = false;
            opt_1_PPK1.Visible = opt_1_PPK1Podstawa.Visible = opt_1_PPK1SkładkaPodstawowaNag.Visible = opt_1_PPK1SkładkaUNag.Visible = opt_1_PPK1SkładkaFNag.Visible = opt_1_PPK1SkładkaUPodstawowa.Visible = opt_1_PPK1SkładkaFPodstawowa.Visible = opt_1_PPK1SkładkaDodatkowaNag.Visible = opt_1_PPK1SkładkaFDodatkowa.Visible = opt_1_PPK1SkładkaUDodatkowa.Visible = false;
            opt_1_PPK2.Visible = opt_1_PPK2Podstawa.Visible = opt_1_PPK2SkładkaPodstawowaNag.Visible = opt_1_PPK2SkładkaUNag.Visible = opt_1_PPK2SkładkaFNag.Visible = opt_1_PPK2SkładkaUPodstawowa.Visible = opt_1_PPK2SkładkaFPodstawowa.Visible = opt_1_PPK2SkładkaDodatkowaNag.Visible = opt_1_PPK2SkładkaFDodatkowa.Visible = opt_1_PPK2SkładkaUDodatkowa.Visible = ppk;
            opt_1_PPK2Empty.Visible = !ppk;
            opt_1_Wypadkowe.ColSpan = 2;
            opt_1_WypadkowePodstawa.ColSpan = 2;
            opt_1_WypadkowePrac.ColSpan = 2;
            opt_1_WypadkoweFirma.ColSpan = 2;

            opt_1_Emerytalne.ColSpan = opt_1_EmerytalnePodstawa.ColSpan = opt_1_EmerytalnePrac.ColSpan = opt_1_EmerytalneFirma.ColSpan = 1;
        }
        else {
            opt_1_FP.Visible = opt_1_FPPodstawa.Visible = opt_1_FPSkladka.Visible = opt_1_FPEmptyEnd.Visible = false;
            opt_1_FGSP.Visible = opt_1_FGSPPodstawa.Visible = opt_1_FGSPSkladka.Visible = opt_1_FGSPEmptyEnd.Visible = false;
            opt_1_FEP.Visible = opt_1_FEPPodstawa.Visible = opt_1_FEPSkladka.Visible = opt_1_FEPEmptyEnd.Visible = false;

            if (ppk) {
                opt_1_EmptyEnd.Visible = false;
                opt_1_PPK1.Visible = opt_1_PPK1Podstawa.Visible = opt_1_PPK1SkładkaPodstawowaNag.Visible = opt_1_PPK1SkładkaUNag.Visible = opt_1_PPK1SkładkaFNag.Visible = opt_1_PPK1SkładkaUPodstawowa.Visible = opt_1_PPK1SkładkaFPodstawowa.Visible = opt_1_PPK1SkładkaDodatkowaNag.Visible = opt_1_PPK1SkładkaFDodatkowa.Visible = opt_1_PPK1SkładkaUDodatkowa.Visible = true;
                
                opt_1_PPK2.Visible = opt_1_PPK2Podstawa.Visible = opt_1_PPK2SkładkaPodstawowaNag.Visible = opt_1_PPK2SkładkaUNag.Visible = opt_1_PPK2SkładkaFNag.Visible = opt_1_PPK2SkładkaUPodstawowa.Visible = opt_1_PPK2SkładkaFPodstawowa.Visible = opt_1_PPK2SkładkaDodatkowaNag.Visible = opt_1_PPK2SkładkaFDodatkowa.Visible = opt_1_PPK2SkładkaUDodatkowa.Visible = false;
                opt_1_PPK2Empty.Visible = true;
                opt_1_Emerytalne.ColSpan = opt_1_EmerytalnePodstawa.ColSpan = opt_1_EmerytalnePrac.ColSpan = opt_1_EmerytalneFirma.ColSpan = 2;
            }
        }
        opt_1_FEPEmpty.Visible = !opt_1_FEP.Visible;

        decimal pitKoszty = 0, pitKoszty50 = 0, pitKoszty50N = 0;
        foreach (WypElement we in wypłata.Elementy)
            switch (we.Definicja.Deklaracje.Koszty.Typ) {
                case TypKosztowUzyskaniaPrzychodu.Procentowe:
                case TypKosztowUzyskaniaPrzychodu.Procentowe50:
                case TypKosztowUzyskaniaPrzychodu.ProcentoweWarunkowo:
                    if (we.Definicja.Deklaracje.Koszty.Procent == new Percent(0.5M)) {
                        if (we.Podatki.Koszty > 0)
                            pitKoszty50 += we.Podatki.Koszty;
                        else
                            pitKoszty50 += we.Podatki.Koszty50;
                    }
                    else {
                        pitKoszty += we.Podatki.Koszty;
                        pitKoszty50 += we.Podatki.Koszty50;
                    }
                    break;
                default:
                    pitKoszty += we.Podatki.Koszty;
                    pitKoszty50 += we.Podatki.Koszty50;
                    break;
            }
       col_1_PitKoszty.Format = col_2_PitKoszty.Format = "";
        if (pitKoszty != 0) {
           col_1_KosztyFormat.Format = col_2_KosztyFormat.Format = "Koszty uz.:";
           col_1_PitKoszty.Format = col_2_PitKoszty.Format = pitKoszty.ToString();
        }
        if (pitKoszty50 != 0) {
           col_1_KosztyFormat.Format += (pitKoszty != 0 ? "<br/>" : "") + "Koszty uz.50%:";
           col_2_KosztyFormat.Format += (pitKoszty != 0 ? "<br/>" : "") + "Koszty uz.50%:";
           col_1_PitKoszty.Format += (pitKoszty != 0 ? "<br/>" : "") + pitKoszty50.ToString();
           col_2_PitKoszty.Format += (pitKoszty != 0 ? "<br/>" : "") + pitKoszty50.ToString();
        }
        FromTo ow = new FromTo(wypłata.Data.FirstDayYear(), wypłata.Data);
        PlaceModule pm = PlaceModule.GetInstance(wypłata.Pracownik);
        SubTable st = new SubTable(pm.WypElementy.WgDaty[wypłata.Pracownik], ow);
        foreach (WypElement we in st) {
            try {
                switch (we.Definicja.Deklaracje.Koszty.Typ) {
                    case TypKosztowUzyskaniaPrzychodu.Procentowe:
                    case TypKosztowUzyskaniaPrzychodu.Procentowe50:
                    case TypKosztowUzyskaniaPrzychodu.ProcentoweWarunkowo:
                        if (we.Definicja.Deklaracje.Koszty.Procent == new Percent(0.5M)) {
                            if (we.Podatki.Koszty > 0)
                                pitKoszty50N += we.Podatki.Koszty;
                            else
                                pitKoszty50N += we.Podatki.Koszty50;
                        }
                        else
                            pitKoszty50N += we.Podatki.Koszty50;
                        break;
                    default:
                        pitKoszty50N += we.Podatki.Koszty50;
                        break;
                }
            }
            catch { }
        }
        if (pitKoszty50N != 0) {
           col_1_KosztyFormat.Format += (pitKoszty != 0 || pitKoszty50 != 0 ? "<br/>" : "") + "Narast.k.uz.50%:";
           col_2_KosztyFormat.Format += (pitKoszty != 0 || pitKoszty50 != 0 ? "<br/>" : "") + "Narast.k.uz.50%:";
           col_1_PitKoszty.Format += (pitKoszty != 0 || pitKoszty50 != 0 ? "<br/>" : "") + pitKoszty50N.ToString();
           col_2_PitKoszty.Format += (pitKoszty != 0 || pitKoszty50 != 0 ? "<br/>" : "") + pitKoszty50N.ToString();
        }
    }

	//Pomocne w trakcie szukania błądów
	static void Msg(object obj) {
	}    

    </script>
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <font face="Tahoma">
        <form id="form" method="post" runat="server">
            <p>
                <ea:datacontext id="dc" runat="server" oncontextload="dc_ContextLoad" RightMargin="-1" LeftMargin="-1"
                    TypeName="Soneta.Place.Wyplata,Soneta.KadryPlace">
                </ea:datacontext>
            </p>
            <ea:Section runat="server" SectionType="Header"></ea:Section>
            <ea:Section runat="server" SectionType="Body">
                <ea:Grid id="GridFirma" runat="server" ShowHeader="None" RowsInRow="4" RowTypeName="Soneta.Business.Session,Soneta.Business" WithSections="False">
                    <columns>
                        <ea:GridColumn RightBorder="None" Format="Nazwa firmy: " ID="colFirmaTitle"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="NIP:" ID="colNipTitle"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="NUSP:" ID="colNuspTitle"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" ID="c1"></ea:GridColumn>
                        <ea:GridColumn colSpan="4" BottomBorder="None" ID="colNazwaFirmy"></ea:GridColumn>
                        <ea:GridColumn colSpan="4" ID="colNIP" EncodeHTML="false"></ea:GridColumn>
                        <ea:GridColumn colSpan="4" ID="colNUSP" EncodeHTML="false"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" ID="c2"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" ID="c3"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" ID="c4"></ea:GridColumn>
                        <ea:GridColumn ID="c5"></ea:GridColumn>
                        <ea:GridColumn colSpan="4" Align="Center" Format="&lt;font size=1&gt;......................................&lt;br&gt;(pieczęć firmy)&lt;/font&gt;"
                            ID="colStempel" RowSpan="4" VAlign="Bottom">
                        </ea:GridColumn>
                    </columns>
                </ea:Grid>
                <ea:Section ID="sectionPPK" runat="server">
                <ea:grid id="gridHeader" runat="server" onbeforerow="gridHeader_BeforeRow" RowsInRow="12" ShowHeader="None"
                    WithSections="False" RowTypeName="Soneta.Place.Wyplata, Soneta.KadryPlace">
                    <columns>
                        <ea:GridColumn RightBorder="None" Format="Pracownik:"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Za okres:"></ea:GridColumn>
                        <ea:GridColumn BottomBorder="Single" ColSpan="6" ID="col_1_PracInfo"></ea:GridColumn>
                        <ea:GridColumn></ea:GridColumn>
                        <ea:GridColumn Format="Podstawa:"></ea:GridColumn>
                        <ea:GridColumn Format="Ubezpieczony:"></ea:GridColumn>
                        <ea:GridColumn Format="Płatnik:" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_EmptyBegin" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_Podstawa" runat="server" Format="Podstawa:"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_Skladka" runat="server" Format="Składka:"></ea:GridColumn>
                        <ea:GridColumn RowSpan="2"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_EmptyEnd" RowSpan="3" runat="server"></ea:GridColumn>

                        <ea:GridColumn ID="col_1_Pracownik" ColSpan="5" DataMember="Pracownik" Format="&lt;strong&gt;{0}&lt;/strong&gt;"></ea:GridColumn>
                        <ea:GridColumn ID="col_1_OkresInfo" ColSpan="5"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_Emerytalne" Align="Center" Format="Emerytalne"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_EmerytalnePodstawa" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_EmerytalnePrac" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Prac" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_EmerytalneFirma" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FP" runat="server" Align="Center" Format="FP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FP.Firma"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FPEmptyEnd" RowSpan="3"></ea:GridColumn>

                        <ea:GridColumn id="opt_1_PPK1" colSpan="3" runat="server" Align="Center" Format="PPK" BottomBorder="None"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1Podstawa" colSpan="3" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaPodstawowaNag" colSpan="2" runat="server" Align="Center" Format="Podstawowa"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaUNag" RightBorder="None" Align="Center" Width="4" Format="U"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaFNag" RightBorder="None" Align="Center" Width="4" Format="F"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaUPodstawowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Składka" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaFPodstawowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Składka" Format="{0:n}"></ea:GridColumn>


                        <ea:GridColumn Align="Center" Format="Rentowe"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Prac" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaDodatkowaNag" runat="server" Align="Center" Format="Dodatkowa" CssClass="c0"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaUDodatkowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Składka" Format="{0:n}" CssClass="c0"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK1SkładkaFDodatkowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Składka" Format="{0:n}" CssClass="c0"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FGSP" runat="server" Align="Center" Format="FGŚP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FGSPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FGSP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FGSPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FGSP.Firma"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FGSPEmptyEnd" RowSpan="3"></ea:GridColumn>

                        <ea:GridColumn Align="Center" Format="Chorobowe"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Prac" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>

                        <ea:GridColumn ID="opt_1_FEP" runat="server" Align="Center" Format="FEP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FEPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FEP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FEPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FEP.Firma"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FEPEmptyEnd" RowSpan="3"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_FEPEmpty" RowSpan="5" runat="server" RightBorder="None"></ea:GridColumn>

                        <ea:GridColumn id="opt_1_Wypadkowe" Align="Center" Format="Wypadkowe"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_WypadkowePodstawa" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_WypadkowePrac" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Prac" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_WypadkoweFirma" Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>

                        <ea:GridColumn id="opt_1_PPK2" colSpan="3" runat="server" Align="Center" Format="PPK" BottomBorder="None"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2Podstawa" colSpan="3" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaPodstawowaNag" colSpan="2" runat="server" Align="Center" Format="Podstawowa"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaUNag" RightBorder="None" Align="Center" Width="4" Format="U"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaFNag" RightBorder="None" Align="Center" Width="4" Format="F"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaUPodstawowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.PodstPracownika" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaFPodstawowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.PodstPracodawcy" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn ID="opt_1_PPK2Empty" RowSpan="5" colSpan="2" runat="server" RightBorder="None"></ea:GridColumn>

                        <ea:GridColumn colSpan="2" DataMember="Numer" Format="&lt;strong&gt;{0}&lt;/strong&gt;"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Oddział NFZ:"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" BottomBorder="Single" Format="Procent zal. PIT:" ID="col_1_PitInfo"></ea:GridColumn>
                        <ea:GridColumn Align="Center" Format="Razem"></ea:GridColumn>
                        <ea:GridColumn></ea:GridColumn>

                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.KosztyZUS" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.FirmaZUS" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaDodatkowaNag" runat="server" Align="Center" Format="Dodatkowa" CssClass="c0"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaUDodatkowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.DodPracownika" Format="{0:n}" CssClass="c0"></ea:GridColumn>
                        <ea:GridColumn id="opt_1_PPK2SkładkaFDodatkowa" runat="server" Align="Right" DataMember="Workers.WyplataSkładki.Razem.PPK.DodPracodawcy" Format="{0:n}" CssClass="c0"></ea:GridColumn>

                        <ea:GridColumn DataMember="PracHistoria.OddzialNFZ.Kod"></ea:GridColumn>
                        <ea:GridColumn BottomBorder="Single" DataMember="Workers.PITInfo.ProcentPit" ID="col_1_PitProcent"></ea:GridColumn>
                        <ea:GridColumn Align="Center" Format="Zdrowotne"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Podstawa" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>

                        <ea:GridColumn RowSpan="5" runat="server" RightBorder="None"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" ID="col_1_KosztyFormat" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Ulga podatkowa:" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn9" RightBorder="None" Format="Zdrow.do odlicz.:" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Zdrow. prac.:" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Zal. podatku:" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="Got&#243;wka:" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn RightBorder="None" Format="ROR:" NoWrap="True" BottomBorder="Single"></ea:GridColumn>

                        <ea:GridColumn RowSpan="5" runat="server" RightBorder="None"></ea:GridColumn>
                        <ea:GridColumn Align="Right" ID="col_1_PitKoszty" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.PITInfo.Ulga" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn ID="GridColumn10" Align="Right" DataMember="Workers.PITInfo.ZdrowotneDoOdliczenia" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.PITInfo.ZdrowotnePracownika" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" DataMember="Workers.PITInfo.ZalFIS" Format="{0:n}"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Format="&lt;strong&gt;{0}&lt;/strong&gt;" ID="col_1_Gotowka"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Format="&lt;strong&gt;{0}&lt;/strong&gt;" ID="col_1_ROR" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn RowSpan="5" runat="server" RightBorder="None"></ea:GridColumn>
                    </columns>
                </ea:grid>
                </ea:Section>
                <ea:Section ID="sectionNormal" runat="server">
                <ea:grid id="gridHeader1" runat="server" onbeforerow="gridHeader_BeforeRow" RowsInRow="10" ShowHeader="None"
					WithSections="False" RowTypeName="Soneta.Place.Wyplata, Soneta.KadryPlace">
					<Columns>
						<ea:GridColumn RightBorder="None" Format="Pracownik:"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Za okres:"></ea:GridColumn>
						<ea:GridColumn ColSpan="5" BottomBorder="Single" ID="col_2_PracInfo"></ea:GridColumn>
						<ea:GridColumn></ea:GridColumn>
						<ea:GridColumn Format="Podstawa:"></ea:GridColumn>
						<ea:GridColumn Format="Ubezpieczony:"></ea:GridColumn>
						<ea:GridColumn Format="Płatnik:" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_EmptyBegin" runat="server"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_Podstawa" runat="server" Format="Podstawa:"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_Skladka" runat="server" Format="Składka:"></ea:GridColumn>
						<ea:GridColumn ColSpan="4" DataMember="Pracownik" Format="&lt;strong&gt;{0}&lt;/strong&gt;"></ea:GridColumn>
						<ea:GridColumn ColSpan="4" ID="col_2_OkresInfo"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Emerytalne"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Podstawa" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Prac" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Emerytalna.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FP" runat="server" Align="Center" Format="FP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FP.Firma"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Rentowe"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Podstawa" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Prac" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Rentowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FGSP" runat="server" Align="Center" Format="FGŚP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FGSPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FGSP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FGSPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FGSP.Firma"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Chorobowe"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Podstawa" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Prac" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Chorobowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FEP" runat="server" Align="Center" Format="FEP"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FEPPodstawa" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FEP.Podstawa"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_FEPSkladka" runat="server" Align="Right" Format="{0:n}" DataMember="Workers.WyplataSkładki.Razem.FEP.Firma"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Wypadkowe"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Podstawa" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Prac" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Wypadkowa.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
                        <ea:GridColumn ID="opt_2_EmptyEnd" runat="server" ColSpan="5" RowSpan="3"></ea:GridColumn>
						<ea:GridColumn ColSpan="2" DataMember="Numer" Format="&lt;strong&gt;{0}&lt;/strong&gt;"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Oddział NFZ:"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" BottomBorder="Single" Format="Procent zal. PIT:" ID="col_2_PitInfo"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Razem"></ea:GridColumn>
						<ea:GridColumn></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.KosztyZUS" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.FirmaZUS" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
						<ea:GridColumn DataMember="PracHistoria.OddzialNFZ.Kod"></ea:GridColumn>
						<ea:GridColumn BottomBorder="Single" DataMember="Workers.PITInfo.ProcentPit" ID="col_2_PitProcent"></ea:GridColumn>
						<ea:GridColumn Align="Center" Format="Zdrowotne"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Podstawa" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Prac" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.WyplataSkładki.Razem.Zdrowotna.Firma" Format="{0:n}" BottomBorder="Single"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" ID="col_2_KosztyFormat" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Ulga podatkowa:" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn9_1" RightBorder="None" Format="Zdrow.do odlicz.:" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Zdrow. prac.:" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Zal. podatku:" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="Got&#243;wka:" NoWrap="True"></ea:GridColumn>
						<ea:GridColumn RightBorder="None" Format="ROR:" NoWrap="True" BottomBorder="Single"></ea:GridColumn>
						<ea:GridColumn Align="Right" ID="col_2_PitKoszty" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.PITInfo.Ulga" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn ID="GridColumn10_1" Align="Right" DataMember="Workers.PITInfo.ZdrowotneDoOdliczenia" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.PITInfo.ZdrowotnePracownika" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" DataMember="Workers.PITInfo.ZalFIS" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Align="Right" Format="&lt;strong&gt;{0}&lt;/strong&gt;" ID="col_2_Gotowka"></ea:GridColumn>
						<ea:GridColumn Align="Right" Format="&lt;strong&gt;{0}&lt;/strong&gt;" ID="col_2_ROR" BottomBorder="Single"></ea:GridColumn>
					</Columns>
				</ea:grid>
                </ea:Section>
                <ea:Grid id="gridElements" runat="server" WithSections="False" onbeforerow="gridElements_BeforeRow"
                    DataMember="ElementyWgKolejności">
                    <columns>
                        <ea:GridColumn Width="4" BottomBorder="None" Align="Right" DataMember="#" Caption="L.p."></ea:GridColumn>
                        <ea:GridColumn BottomBorder="None" Total="Info" ID="colNazwa" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="Procent" HideZero="True" ID="colProcent"
                            VAlign="Top">
                        </ea:GridColumn>
                        <ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="godz:min" HideZero="True"
                            ID="colCzas">
                        </ea:GridColumn>
                        <ea:GridColumn Width="10" BottomBorder="None" Align="Right" Caption="Dni" HideZero="True" ID="colDni"></ea:GridColumn>
                        <ea:GridColumn Width="15" BottomBorder="None" Align="Right" Total="Sum" Caption="Dodatek" HideZero="True"
                            Format="{0:n}" ID="colDodatek">
                        </ea:GridColumn>
                        <ea:GridColumn Width="15" BottomBorder="None" Align="Right" Total="Sum" Caption="Potrącenie" HideZero="True"
                            Format="{0:n}" ID="colPotracenie">
                        </ea:GridColumn>
                        <ea:GridColumn Width="25" BottomBorder="None" Caption="Data i podpis"></ea:GridColumn>
                    </columns>
                </ea:Grid>
                <ea:Grid id="gridFundusze" runat="server" WithSections="False">
                    <columns>
                        <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="L.p."></ea:GridColumn>
                        <ea:GridColumn Width="30" DataMember="Definicja.Nazwa" Caption="Fundusz" NoWrap="True"></ea:GridColumn>
                        <ea:GridColumn Width="15" Align="Right" DataMember="Workers.FundPożyczkowy.Wkład" Caption="Wkład"
                            HideZero="True" Format="{0:n}">
                        </ea:GridColumn>
                        <ea:GridColumn Width="15" Align="Right" DataMember="Workers.FundPożyczkowy.DoSpłaty" Caption="Do spłaty"
                            HideZero="True" Format="{0:n}">
                        </ea:GridColumn>
                    </columns>
                </ea:Grid>
                <ea:Section ID="section1" runat="server">
                    <font size="1">
                        <br />
                        <strong>Oświadczenie płatnika składek</strong><br />
                        <br />
                        Oświadczam, że dane zawarte w formularzu są zgodne ze stanem prawnym i faktycznym.
                    Jestem
				    <ea:DataLabel id="DataLabel2" runat="server" DataMember="PracHistoria.Plec" Bold="False">
                        <valuesmap>
                            <ea:ValuesPair Key="Kobieta" Value="świadomy"></ea:ValuesPair>
                            <ea:ValuesPair Key="Mężczyzna" Value="świadomy"></ea:ValuesPair>
                        </valuesmap>
                    </ea:DataLabel>
                        odpowiedzialności karnej za zeznanie nieprawdy lub zatajenie prawdy.
                    </font>
                </ea:Section>
                <n0:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></n0:ReportFooter>
            </ea:Section>
        </form>
    </font>
</body>
</html>

